/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CMessageBox.h,v 1.3 1999/09/20 01:27:07 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CMessageBox_h	// [
#define Included_CMessageBox_h

#include "pgpClassesConfig.h"
#include "CPath.h"

_PGP_BEGIN

// Class CMessageBox

class CMessageBox
{
	NOT_COPYABLE(CMessageBox)

public:
	enum Style
	{
		kOkStyle, 
		kOkCancelStyle, 
		kYesNoStyle, 
		kYesNoCancelStyle
	};

	enum Button
	{
		kYesButton, 
		kNoButton, 
		kOkButton, 
		kCancelButton
	};

	enum Tone
	{
		kWarningTone, 
		kInfoTone, 
		kQuestionTone, 
		kStopTone, 
	};

public:
	~CMessageBox() { }
	CMessageBox() { }

	Button	Display(const char *message, const char *title = NULL, 
		HWND parentWindow = NULL, Tone = kStopTone, Style style = kOkStyle, 
		Button focus = kOkButton) const;
};

_PGP_END

#endif	// ] Included_CMessageBox_h
